(*| 12:56 27/02/1990 *)
PROGRAM PICLOAD;

USES Crt,Dos;

CONST
  HiResMode=$10;
  MedResMode=$0E;
  TextMode=3;
  BlueP=1;
  GreenP=2;
  RedP=4;
  IntenP=8;
  Head_Size=128;
  BuffSize=10000;

TYPE
  BytePointer = ^Byte;
  RunBlk = RECORD
             Cnt: Byte;
             Pat: Byte;
           END;

VAR
  PicFile:File;
  ScrBuf,BufPtr,BufTop: BytePointer;
  Tail:RunBlk;
  VideoMode,LinesPerScreen,NumOfPlanes,CurPos,StartLine: Integer;
  PicLines,BytesPerLine,Result: Integer;
  EofFlag: Boolean;
  FileName:String[80];

{$L PICLODP}

FUNCTION EgaRun(off:Word;pat,cnt,pln,op,pg:Integer):WORD;
EXTERNAL;

PROCEDURE VMode(Mode:Byte);
VAR
  Regs:Registers;
BEGIN
  WITH Regs DO BEGIN
    AH:=0;
    AL:=Mode;
  END;
  INTR($10,Regs);
END;  { VMode }

FUNCTION IndexPtr(OldPtr:BytePointer; Index: Integer):BytePointer;
BEGIN
  IndexPtr:=Ptr(Seg(OldPtr^),Ofs(OldPtr^)+Index);
END;  { IndexPtr }

PROCEDURE BRefresh(MaxRead:Integer);
VAR
  NumRead:Integer;
BEGIN
  BlockRead(PicFile,ScrBuf^,MaxRead,NumRead);
  EofFlag:=(NumRead=0);
  BufPtr:=ScrBuf;
  BufTop:=IndexPtr(ScrBuf,NumRead);
END;  { BRefresh }

PROCEDURE GFByte(VAR B:Byte);
BEGIN
  IF BufPtr=BufTop THEN BEGIN
    IF NOT EofFlag THEN BEGIN
      BRefresh(BuffSize);
      B:=BufPtr^;
      BufPtr:=IndexPtr(BufPtr,1);
    END ELSE
      B:=0;
  END ELSE BEGIN
    B:=BufPtr^;
    BufPtr:=IndexPtr(BufPtr,1);
  END;
END;  { GFByte }

PROCEDURE PicRead(VAR Blk:RunBlk);
VAR
  B:Byte;
BEGIN
  GFByte(B);
  WITH Blk DO IF (B AND $C0)=$C0 THEN BEGIN
    Cnt:=B AND $3F;
    GFByte(B);
    Pat:=B;
  END ELSE BEGIN
    Cnt:=1;
    Pat:=B;
  END;
END;  { PicRead }

PROCEDURE GetPix(VAR Blk:RunBlk);
BEGIN
  IF Tail.Cnt <> 0 THEN BEGIN
    Blk.Cnt:=Tail.Cnt;
    Blk.Pat:=Tail.Pat;
    CurPos:=Tail.Cnt;
    Tail.Cnt:=0;
  END ELSE BEGIN
    PicRead(Blk);
    CurPos:=CurPos+Blk.Cnt;
    IF (CurPos > 80) THEN BEGIN
      Tail.Cnt:=CurPos-80;
      Blk.Cnt:=Blk.Cnt-Tail.Cnt;
      Tail.Pat:=Blk.Pat;
      CurPos:=0;
    END;
  END;
END;  { GetPix }

PROCEDURE PicLine(Plane,Line,Op: Integer);
VAR
  CurPix:RunBlk;
  I:Integer;
  StartAd,EndAd,CurAd:Word;
BEGIN
  IF Line < StartLine THEN
    CurAd:=0
  ELSE
    CurAd:=(Line-StartLine)*80;
  I:=0;
  StartAd:=CurAd;
  EndAd:=CurAd+80;
  REPEAT
    IF EofFlag THEN BEGIN
      I:=80;
      EXIT;
    END;
    GetPix(CurPix);
    WITH CurPix DO IF Cnt <> 0 THEN BEGIN
      IF Pat <> $FF THEN BEGIN
        Pat:=Pat+0;
      END;
      IF CurAd < (EndAd) THEN
        CurAd:=EgaRun(CurAd,Pat,Cnt,Plane,Op,0);
      I:=I+Cnt;
    END;
  UNTIL I >= BytesPerLine;
END;  { PicLine }

PROCEDURE PutPic;
VAR
  PLine:Integer;
BEGIN
  PLine:=0;
  WHILE NOT EofFlag DO BEGIN
    IF NumOfPlanes=1 THEN BEGIN
      PicLine(BlueP+GreenP+RedP+IntenP,PLine,0);
    END ELSE IF NumOfPlanes=4 THEN BEGIN
      PicLine(BlueP,PLine,0);
      PicLine(GreenP,PLine,$10);
      PicLine(RedP,PLine,$10);
      PicLine(IntenP,PLine,$10);
    END;
    INC(PLine);
    IF PLine > (StartLine+LinesPerScreen) THEN
      EXIT;
  END;
END;  { PutPic }

PROCEDURE PLExit;
BEGIN
  WHILE NOT KeyPressed DO ;
  VMode(TextMode);
  Writeln('Num Of Planes ',NumOfPlanes);
  Writeln('Bytes Per Line ',BytesPerLine);
  Writeln('Start Line ',StartLine);
  Writeln('Pic Lines ',PicLines);
END;  { PLExit }

PROCEDURE ReadHead;
BEGIN
  BRefresh(Head_Size);
  PicLines:=(IndexPtr(ScrBuf,15)^ * 256) + IndexPtr(ScrBuf,14)^;
  NumOfPlanes:=IndexPtr(ScrBuf,65)^;
  BytesPerLine:=IndexPtr(ScrBuf,66)^;
  Seek(PicFile,Head_Size);
END;  { ReadHead }

BEGIN
  StartLine:=0;
  VideoMode:=HiResMode;
  IF VideoMode=HiResMode THEN
    LinesPerScreen:=350
  ELSE
    LinesPerScreen:=200;
  IF ParamCount > 0 THEN
    FileName:=ParamStr(1)
  ELSE BEGIN
    Write('Specify .PCX file ! : ');
    Readln(FileName);
  END;
  IF ParamCount > 1 THEN BEGIN
    Val(ParamStr(2),StartLine,Result);
  END;
  IF POS('.',FileName)=0 THEN
    FileName:=FileName+'.PCX';
  ASSIGN(PicFile,FileName);
{$I-}
  RESET(PicFile,1);
{$I+}
  IF IOResult <> 0 THEN BEGIN
    Writeln('Cannot open .PCX file ',FileName);
    HALT;
  END;
  GetMem(ScrBuf,BuffSize);
  BufPtr:=ScrBuf;
  BufTop:=ScrBuf;
  EofFlag:=False;
  ReadHead;
  IF StartLine=-1 THEN
    StartLine:=PicLines;
  IF PicLines < LinesPerScreen THEN
    StartLine:=0
  ELSE BEGIN
    IF StartLine > PicLines-LinesPerScreen THEN
      StartLine:=PicLines-LinesPerScreen;
  END;
  BufPtr:=ScrBuf;
  BufTop:=ScrBuf;
  CurPos:=0;
  Tail.Cnt:=0;
  VMode(VideoMode);
  PutPic;
  PLExit;
END.
